% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbpiper_pe.r
\name{leftCI}
\alias{leftCI}
\title{Return the left value of the parameter confidence interval. The provided dataset has two columns: ObjVal | ParamValue}
\usage{
leftCI(smallest.param.value, full_dataset, cl_objval)
}
\arguments{
\item{smallest.param.value}{the smallest parameter value within the specified confidence level}

\item{full_dataset}{the full dataset}

\item{cl_objval}{the objective value at the desired confidence level}
}
\value{
the left confidence interval
}
\description{
Return the left value of the parameter confidence interval. The provided dataset has two columns: ObjVal | ParamValue
}
\examples{
data(insulin_receptor_all_fits)
colnames(insulin_receptor_all_fits)[1] <- "ObjVal"
min_objval <- min(insulin_receptor_all_fits[,1])
# compute the stats for parameter k2. 
insulin_receptor_all_fits <- subset(insulin_receptor_all_fits, select=c(1,3))
leftCI(smallest.param.value=0.466971, 
        full_dataset=insulin_receptor_all_fits, 
        cl_objval=min_objval+0.01)
leftCI(smallest.param.value=0.467000, 
        full_dataset=insulin_receptor_all_fits, 
        cl_objval=min_objval+0.01)
}
