% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_pomdp.R
\name{sim_pomdp}
\alias{sim_pomdp}
\title{simulate a POMDP}
\usage{
sim_pomdp(
  transition,
  observation,
  reward,
  discount,
  state_prior = rep(1, dim(observation)[[1]])/dim(observation)[[1]],
  x0,
  a0 = 1,
  Tmax = 20,
  policy = NULL,
  alpha = NULL,
  reps = 1,
  ...
)
}
\arguments{
\item{transition}{Transition matrix, dimension n_s x n_s x n_a}

\item{observation}{Observation matrix, dimension n_s x n_z x n_a}

\item{reward}{reward matrix, dimension n_s x n_a}

\item{discount}{the discount factor}

\item{state_prior}{initial belief state, optional, defaults to uniform
over states}

\item{x0}{initial state}

\item{a0}{initial action (default is action 1, e.g. can be arbitrary
if the observation process is independent of the action taken)}

\item{Tmax}{duration of simulation}

\item{policy}{Simulate using a pre-computed policy (e.g. MDP policy) instead of POMDP}

\item{alpha}{the matrix of alpha vectors returned by \code{\link{sarsop}}}

\item{reps}{number of replicate simulations to compute}

\item{...}{additional arguments to mclapply}
}
\value{
a data frame with columns for time, state, obs, action, and (discounted) value.
}
\description{
Simulate a POMDP given the appropriate matrices.
}
\details{
simulation assumes the following order of updating: For system in state[t] at
time t, an observation of the system obs[t] is made, and then action[t] is based on that
observation and the given policy, returning (discounted) reward[t].
}
\examples{
m <- fisheries_matrices()
discount <- 0.95
\donttest{ ## Takes > 5s
if(assert_has_appl()){
alpha <- sarsop(m$transition, m$observation, m$reward, discount, precision = 10)
sim <- sim_pomdp(m$transition, m$observation, m$reward, discount,
                 x0 = 5, Tmax = 20, alpha = alpha)

}}

}
