% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_r_files.R
\name{create_r_files}
\alias{create_r_files}
\title{Create Folder with Placeholder R-files Based on Structure in CSV-file}
\usage{
create_r_files(
  r_files_out_path,
  r_files_source_path = system.file("templates", "r_files.csv", package = "saros.base"),
  r_optionals = TRUE,
  r_add_file_scope = TRUE,
  r_prefix_file_scope = "### ",
  r_add_folder_scope_as_README = FALSE,
  word_separator = NULL,
  case = c("asis", "sentence", "title", "lower", "upper", "snake"),
  numbering_prefix = c("none", "max_local", "max_global"),
  numbering_inheritance = TRUE,
  numbering_parent_child_separator = word_separator,
  numbering_name_separator = " "
)
}
\arguments{
\item{r_files_out_path}{String, path to where to place R placeholder files. If NULL, will not create any.}

\item{r_files_source_path}{String, path to where to find CSV-field containing the columns folder_name, folder_scope, file_name, file_scope. If NULL, defaults to system.file("templates", "r_files.csv")).}

\item{r_optionals}{Flag. Whether to add files marked as 1 (or TRUE) in the optional column. Defaults to TRUE.}

\item{r_add_file_scope}{Flag. Whether to add value from column 'file_scope' to beginning of each file. Default to TRUE.}

\item{r_prefix_file_scope}{String to add before file_scope. Defaults to "### "}

\item{r_add_folder_scope_as_README}{Flag. Whether to create README file in each folder with the folder_scope column cell in r_files_source_path. Defaults to FALSE.}

\item{word_separator}{String. Replace separators between words in folder names. Defaults to NULL.}

\item{case}{String. One of c("asis", "sentence", "lower", "upper", "title", "snake").}

\item{numbering_prefix}{String. One of c("none", "max_local", "max_global").}

\item{numbering_inheritance}{Flag. Whether to inherit numbering from parent folder.}

\item{numbering_parent_child_separator}{String. Defaults to word_separator.}

\item{numbering_name_separator}{String. Separator between numbering part and name.}
}
\value{
No return value, called for side effects
}
\description{
Create Folder with Placeholder R-files Based on Structure in CSV-file
}
\examples{
create_r_files(r_files_out_path = tempdir())
}
