% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssh.test.r
\name{ssh.test}
\alias{ssh.test}
\title{Evaluate stratification}
\usage{
ssh.test(object,
       y,
       x,
       test="factor",
       type="shp")
}
\arguments{
\item{object}{An object generated by \code{\link{ssh.data.shp}} or \code{\link{ssh.data.txt}}.}

\item{y}{Text for the name of the explained variable (sampling attribute) in \code{object}.}

\item{x}{Text for the name(s) of the explanatory variable(s) (stratification(s)) in \code{object}.}

\item{test}{Text for the type of test. \code{test="factor"} denotes the factor detector, and \code{test="interaction"} denotes the interaction detector. By default, \code{test="factor"}.}

\item{type}{Text for the type of input data. \code{type="shp"} denotes shapefiles, and \code{type="txt"} denotes text files. By default, \code{type="shp"}.}
}
\value{
A value of the \emph{q}-statistic or the combined \emph{q}-statistic.
}
\description{
Calculate the factor detector \emph{q}-statistic and the interaction detector in the geographical detector model described by Wang et al. (2010). The \emph{q}-statistic measures the SSH of the sampling attribute in terms of a given stratification, which can be used for the selection of an SSH layer for Sandwich model-based mapping. The interactive effects indicate whether a combination of two stratifications enhances the SSH of the sampling attribute.
}
\examples{
library(sf)
library(tools)
data(hs.data)
hs.ssh2.name <- system.file("extdata", "hs.ssh2.shapefile.shp",
                            package="sandwichr")
hs.ssh2 <- read_sf(dsn=dirname(hs.ssh2.name),
                  layer=file_path_sans_ext(basename(hs.ssh2.name)))
hs.join <- ssh.data.shp(object=hs.data[[1]], ssh.lyr=hs.data[[2]], ssh.id="STR_1")
hs.join <- ssh.data.shp(object=hs.join, ssh.lyr=hs.ssh2, ssh.id="STR_2")
ssh.test(object=hs.join, y="Population", x=c("STR_1", "STR_2"), test="factor")

}
\references{
Wang, J. F., Li, X. H., Christakos, G., Liao, Y. L., Zhang, T., Gu, X., & Zheng, X. Y. (2010). Geographical detectors-based health risk assessment and its application in the neural tube defects study of the Heshun Region, China. \emph{International Journal of Geographical Information Science}, 24(1), 107-127.
}
\seealso{
\code{\link{ssh.data.shp}}, \code{\link{ssh.data.txt}}
}
