% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sys.utils.R
\name{sys.intercorr}
\alias{sys.intercorr}
\title{Stratified correlation coefficient}
\usage{
sys.intercorr(N, n, data)
}
\arguments{
\item{N}{Population size}

\item{n}{Sample size}

\item{data}{Population data}
}
\value{
Correlation coefficient
}
\description{
Stratified correlation coefficient
}
\details{
This value serves as a comparison between systematic and stratified sampling precision.\cr
At value=1 the systematic precision is minimum. At value=0 both sampling methods precision
are equal. At value= \eqn{\frac{-1}{n-1}} systematic precision is maximum.\cr
Summarising at values between 1 and 0 stratified sampling estimation has more precision
than systematic, so method="strata" should be set at \code{\link{sys.estimator}}.
The other way method="sys" of interpenetrating samples method is better.
}
\examples{
data<-c(1,3,5,2,4,6,2,7,3)
sys.intercorr(9,3,data)  #0.09022556
}
