% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sys.estimator.R
\name{sys.estimator}
\alias{sys.estimator}
\title{Parameter estimation on a systematic sample}
\usage{
sys.estimator(
  N,
  sample,
  estimator = c("total", "mean", "proportion", "class total"),
  method = c("srs", "strata", "sys"),
  alpha,
  data,
  t
)
}
\arguments{
\item{N}{Population size}

\item{sample}{Vector containing the systematic sample}

\item{estimator}{Estimator to compute. Can be one of "total", "mean", "proportion", "class total". Default is "total".}

\item{method}{Method of variance estimation. Can be one of "srs", "strata", "sys".}

\item{alpha}{Optional value to calculate estimation error and build 1-alpha confidence interval.}

\item{data}{Population data.}

\item{t}{Number of systematic samples to take with interpenetrating samples method.}
}
\value{
A list containing different interest values:
 \itemize{
   \item estimator
   \item variance
   \item sampling.error
   \item estimation.error
   \item confint
 }
}
\description{
Parameter estimation on a systematic sample
}
\details{
Variance estimation has no direct formula in systematic sampling, thus estimation method must be done. Refer to \code{\link{sys.intracorr}}
and \code{\link{sys.intercorr}} functions details for more information. \cr
"sys" method uses interpenetrating samples method in which t systematic samples of size=\eqn{\frac{n}{t}} are taken to estimate. \eqn{\frac{n}{t}} must be even.\cr
By choosing the start at random for all the samples they can be considered random taken. With this method population data and t must be given.
}
\examples{
data<-c(1,3,5,2,4,6,2,7,3)
sample<-sys.sample(9, 3, data)
sys.estimator(N=9, sample, "mean", "srs", 0.05)
}
