% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsamp.R
\name{rsamp}
\alias{rsamp}
\title{Draws simple random sample without replacement}
\usage{
rsamp(df, n, over = 0, rep = FALSE)
}
\arguments{
\item{df}{object containing full sampling data frame (e.g. data)}

\item{n}{sample size (integer) or object containing sample size}

\item{over}{(optional) desired oversampling proportion (defaults to 0; takes value between 0 and 1 as input)}

\item{rep}{(optional)}
}
\value{
Returns simple random sample without replacement
}
\description{
Draws simple random sample without replacement
}
\examples{
rsamp(albania, n=360, over=0.1, rep=FALSE)

size <- rsampcalc(nrow(albania), 3, 95, 0.5)
randomsample <- rsamp(albania, size)
}
\references{
Simplified wrapper around dplyr::sample_n()
}
