% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cond_passage.R
\name{cond_passage}
\alias{cond_passage}
\alias{cond_passage,samc,missing,location-method}
\alias{cond_passage,samc,location,location-method}
\title{Conditional Mean First Passage Time}
\usage{
cond_passage(samc, origin, dest)

\S4method{cond_passage}{samc,missing,location}(samc, dest)

\S4method{cond_passage}{samc,location,location}(samc, origin, dest)
}
\arguments{
\item{samc}{A \code{\link{samc-class}} object. This should be output from
the \code{\link{samc}} function.}

\item{origin}{A positive integer or named location representing a cell in the
landscape. Corresponds to row \emph{i} of matrix \emph{P} in the \code{\link{samc-class}}
object. When paired with the dest parameter, multiple values may be provided
as a vector.}

\item{dest}{A positive integer or named location representing a cell in the
landscape. Corresponds to column \emph{j} of matrix \emph{P} in the \code{\link{samc-class}}
object. When paired with the origin parameter, multiple values may be provided
as a vector.}
}
\value{
A numeric vector or a single numeric value
}
\description{
Calculate the mean number of steps to first passage
}
\details{
\eqn{\tilde{t}=\tilde{B}_j^{-1}\tilde{F}\tilde{B}_j{\cdot}1}
\itemize{
  \item \strong{cond_passage(samc, dest)}

The result is a vector where each element corresponds to a cell in the landscape,
and can be mapped back to the landscape using the \code{\link{map}} function.
Element \emph{i} is the mean number of steps before absorption starting from
location \emph{i} conditional on absorption into \emph{j}

  \item \strong{cond_passage(samc, origin, dest)}

The result is a numeric value representing the mean number of steps before
absorption starting from a given origin conditional on absorption into \emph{j}.
}

\strong{WARNING}: This function will crash when used with data representing
a disconnected graph. This includes, for example, isolated pixels or islands
in raster data. This is a result of the transition matrix for disconnected
graphs leading to some equations being unsolvable. Different options
are being explored for how to best identify these situations in data and
handle them accordingly.
}
\section{Performance}{


Any relevant performance information about this function can be found in the
performance vignette: \href{../doc/performance.html}{\code{vignette("performance", package = "samc")}}
}

\examples{
# "Load" the data. In this case we are using data built into the package.
# In practice, users will likely load raster data using the raster() function
# from the raster package.
res_data <- samc::ex_res_data
abs_data <- samc::ex_abs_data
occ_data <- samc::ex_occ_data


# Make sure our data meets the basic input requirements of the package using
# the check() function.
check(res_data, abs_data)
check(res_data, occ_data)


# Create a `samc-class` object with the resistance and absorption data using
# the samc() function. We use the recipricol of the arithmetic mean for
# calculating the transition matrix. Note, the input data here are matrices,
# not RasterLayers. If using RasterLayers, the latlon parameter must be set.
samc_obj <- samc(res_data, abs_data, tr_fun = function(x) 1/mean(x))


# Convert the occupancy data to probability of occurrence
occ_prob_data <- occ_data / sum(occ_data, na.rm = TRUE)


# Calculate short- and long-term metrics using the analytical functions
short_mort <- mortality(samc_obj, occ_prob_data, time = 50)
short_dist <- distribution(samc_obj, origin = 3, time = 50)
long_disp <- dispersal(samc_obj, occ_prob_data)
visit <- visitation(samc_obj, dest = 4)
surv <- survival(samc_obj)


# Use the map() function to turn vector results into RasterLayer objects.
short_mort_map <- map(samc_obj, short_mort)
short_dist_map <- map(samc_obj, short_dist)
long_disp_map <- map(samc_obj, long_disp)
visit_map <- map(samc_obj, visit)
surv_map <- map(samc_obj, surv)
}
