% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_simulations.R
\name{simulateDiscreteSaemix}
\alias{simulateDiscreteSaemix}
\alias{simulateTTESaemix}
\title{Perform simulations under the model for an saemixObject object defined by its log-likelihood}
\usage{
simulateDiscreteSaemix(
  object,
  nsim,
  seed,
  predictions = TRUE,
  uncertainty = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{object}{an saemixObject object returned by the \code{\link{saemix}} function.
The model must contain a slot simulate.function, containing a function with the same structure as the model functions
(arguments (psi, id, xidep)) which returns simulated responses when given a set of individual parameters (psi)
and the corresponding predictors (xidep)}

\item{nsim}{Number of simulations to perform. Defaults to the nb.simpred
element in options}

\item{seed}{if non-null, seed used to initiate the random number generator (defaults to NULL)}

\item{predictions}{Whether the simulated parameters should be used to
compute predictions. Defaults to TRUE. If FALSE, only individual parameters are simulated.}

\item{uncertainty}{Uses uncertainty (currently not implemented). Defaults to FALSE}

\item{verbose}{if TRUE, prints messages (defaults to FALSE)}
}
\description{
This function is used to simulate from discrete response models.
}
\details{
To call this function, the user needs to define a simulate.function matching the model function
in the object. The function will then be used to simulate data under the empirical design,
using the model and estimated parameters from a fit.

This function calls simulate.SaemixObject with the prediction=FALSE option to
simulate individual parameters, then the simulate.function to obtain corresponding predictions.
}
\seealso{
\code{\link{SaemixObject}},\code{\link{saemix}},
\code{\link{simulate.SaemixObject}}
}
\author{
Emmanuelle Comets \href{mailto:emmanuelle.comets@inserm.fr}{emmanuelle.comets@inserm.fr}
}
\keyword{model}
