% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SaemixData.R, R/SaemixModel.R, R/SaemixRes.R, R/aaa_generics.R
\docType{methods}
\name{showall,SaemixData-method}
\alias{showall,SaemixData-method}
\alias{showall,SaemixModel-method}
\alias{showall,SaemixRes-method}
\alias{showall,SaemixObject-method}
\alias{showall-methods}
\alias{showall}
\title{Methods for Function showall}
\usage{
\S4method{showall}{SaemixData}(object)

\S4method{showall}{SaemixModel}(object)

\S4method{showall}{SaemixRes}(object)

showall(object)
}
\arguments{
\item{object}{showall methods are available for objects of type SaemixData,
SaemixModel and SaemixObject}
}
\value{
None
}
\description{
This function is used to visualise the majority of the elements of an object
}
\section{Methods}{

\describe{
\item{list("signature(x = \"SaemixData\")")}{
Prints a extensive summary of a SaemixData object }
\item{list("signature(x = \"SaemixModel\")")}{ Prints a extensive summary of
a SaemixModel object }
\item{list("signature(x = \"SaemixObject\")")}{ Prints a extensive summary
of the results from a SAEMIX fit }
\item{list("signature(x = \"SaemixRes\")")}{ Not user-level }
}
}
\examples{
# A SaemixData object
data(theo.saemix)
saemix.data<-saemixData(name.data=theo.saemix,header=TRUE,sep=" ",na=NA,
  name.group=c("Id"),name.predictors=c("Dose","Time"),
  name.response=c("Concentration"),name.covariates=c("Weight","Sex"),
  units=list(x="hr",y="mg/L",covariates=c("kg","-")), name.X="Time")
showall(saemix.data)

# A SaemixModel object
model1cpt<-function(psi,id,xidep) {
	  dose<-xidep[,1]
	  tim<-xidep[,2]
	  ka<-psi[id,1]
	  V<-psi[id,2]
	  CL<-psi[id,3]
	  k<-CL/V
	  ypred<-dose*ka/(V*(ka-k))*(exp(-k*tim)-exp(-ka*tim))
	  return(ypred)
}
saemix.model<-saemixModel(model=model1cpt,
  description="One-compartment model with first-order absorption",
  psi0=matrix(c(1.,20,0.5,0.1,0,-0.01),ncol=3, byrow=TRUE,
  dimnames=list(NULL, c("ka","V","CL"))),transform.par=c(1,1,1),
  covariate.model=matrix(c(0,1,0,0,0,0),ncol=3,byrow=TRUE),fixed.estim=c(1,1,1),
  covariance.model=matrix(c(1,0,0,0,1,0,0,0,1),ncol=3,byrow=TRUE),
  omega.init=matrix(c(1,0,0,0,1,0,0,0,1),ncol=3,byrow=TRUE),error.model="constant")
showall(saemix.model)
}
\seealso{
\code{\link{SaemixData}},\code{\link{SaemixModel}}, \code{\link{SaemixObject}}
}
\keyword{methods}

