% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare_pred}
\alias{compare_pred}
\alias{compare_pred.saeTrafo}
\title{Compare predictions of model objects}
\usage{
compare_pred(object1, object2, MSE = FALSE, ...)

\method{compare_pred}{saeTrafo}(object1, object2, MSE = FALSE, ...)
}
\arguments{
\item{object1}{an object of type 'saeTrafo'.}

\item{object2}{an object of type 'saeTrafo' or 'emdi'
(\code{\link[emdi]{emdiObject}}).}

\item{MSE}{optional logical. If \code{TRUE}, MSE estimates are returned.
Defaults to \code{FALSE} and than point estimates are returned.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Data frame containing the point estimates or the MSE estimates
(if \code{MSE} is set to \code{TRUE}) of both objects. If column names are
duplicated, the suffixes '_1' and '_2' are added to their names. '_1' and
'_2' standing for object1 and object2, respectively.
}
\description{
Function \code{compare_pred} is a generic function used to compare
predictions of two model objects.

Method \code{compare_pred.saeTrafo} compares predictions of two 'saeTrafo'
objects or a 'saeTrafo' object and an 'emdi' object.
}
\examples{
# Example comparing two 'saeTrafo' objects

\donttest{
# Load Data
data("eusilcA_smp")
data("pop_area_size")
data("pop_mean")
data("pop_cov")

# Nested error regression model 1
NER_model_1 <- NER_Trafo(fixed = eqIncome ~ gender + eqsize + cash +
                         self_empl + unempl_ben + age_ben + surv_ben +
                         sick_ben + dis_ben + rent + fam_allow +
                         house_allow + cap_inv + tax_adj,
                         smp_domains = "district",
                         pop_area_size = pop_area_size,
                         pop_mean = pop_mean, pop_cov = pop_cov,
                         smp_data = eusilcA_smp, MSE = TRUE)

# Nested error regression model 2
NER_model_2 <- NER_Trafo(fixed = eqIncome ~ gender + eqsize + cash +
                         self_empl + unempl_ben + age_ben + surv_ben,
                         smp_domains = "district",
                         pop_area_size = pop_area_size,
                         pop_mean = pop_mean, pop_cov = pop_cov,
                         smp_data = eusilcA_smp, MSE = TRUE)

# Generate a data frame for the comparison of point estimates
compare_pred(NER_model_1, NER_model_2)

# Generate a data frame for the comparison of MSE estimates
compare_pred(NER_model_1, NER_model_2, MSE = TRUE)
}

}
\seealso{
\code{\link{emdi}}, \code{\link{NER_Trafo}},
\code{\link{saeTrafoObject}}
}
