% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustEstimationEquations.R
\name{score}
\alias{score}
\title{Compute values of robust score functions}
\usage{
score(object, filter, ...)
}
\arguments{
\item{object}{a fitted object}

\item{filter}{(character) a selection of values to be computed}

\item{...}{arguments passed to methods}
}
\description{
Can be used to compute the values of the robust estimation equations at their
'solution'.
}
\examples{
data("grapes", package = "sae")

fitRFH <- rfh(
  grapehect ~ area + workdays - 1,
  data = grapes,
  samplingVar = "var"
)

score(fitRFH)
}

