% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_system.R
\name{create}
\alias{create}
\alias{s3_file_create}
\alias{s3_bucket_create}
\alias{s3_dir_create}
\title{Create files and directories}
\usage{
s3_file_create(path, overwrite = FALSE, ...)

s3_bucket_create(
  path,
  region_name = NULL,
  mode = c("private", "public-read", "public-read-write", "authenticated-read"),
  versioning = FALSE,
  ...
)

s3_dir_create(path, overwrite = FALSE, ...)
}
\arguments{
\item{path}{(character): A character vector of path or s3 uri.}

\item{overwrite}{(logical): Overwrite files if the exist. If this is \code{FALSE}
and the file exists an error will be thrown.}

\item{...}{parameters to be passed to \code{\link[paws.storage]{s3_put_object}},
\code{\link[paws.storage]{s3_create_bucket}}}

\item{region_name}{(character): region for \verb{AWS S3} bucket, defaults
to \code{\link[=s3_file_system]{s3_file_system()}} class region.}

\item{mode}{(character): A character of the mode}

\item{versioning}{(logical)}
}
\value{
character vector of s3 uri paths
}
\description{
\code{s3_file_create} create file on \verb{AWS S3}, if file already exists it will be left unchanged.

\code{s3_dir_create} create empty directory of \verb{AWS S3}.
}
\examples{
\dontrun{
# Require AWS S3 credentials

temp_file = s3_file_temp(tmp_dir= "MyBucket")
s3_file_create(temp_file)
}
}
