% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_system.R
\name{s3_file_system}
\alias{s3_file_system}
\title{Access AWS S3 as if it were a file system.}
\usage{
s3_file_system(
  aws_access_key_id = NULL,
  aws_secret_access_key = NULL,
  aws_session_token = NULL,
  region_name = NULL,
  profile_name = NULL,
  endpoint = NULL,
  disable_ssl = FALSE,
  multipart_threshold = fs_bytes("2GB"),
  request_payer = FALSE,
  anonymous = FALSE,
  retries = 5,
  refresh = FALSE,
  ...
)
}
\arguments{
\item{aws_access_key_id}{(character): AWS access key ID}

\item{aws_secret_access_key}{(character): AWS secret access key}

\item{aws_session_token}{(character): AWS temporary session token}

\item{region_name}{(character): Default region when creating new connections}

\item{profile_name}{(character): The name of a profile to use. If not given,
then the default profile is used.}

\item{endpoint}{(character): The complete URL to use for the constructed client.}

\item{disable_ssl}{(logical): Whether or not to use SSL. By default, SSL is used.}

\item{multipart_threshold}{(\link[fs]{fs_bytes}): Threshold to use multipart instead of standard
copy and upload methods.}

\item{request_payer}{(logical): Confirms that the requester knows that they
will be charged for the request.}

\item{anonymous}{(logical): Set up anonymous credentials when connecting to AWS S3.}

\item{retries}{(numeric): max number of retry attempts}

\item{refresh}{(logical): Refresh cached S3FileSystem class}

\item{...}{Other parameters within \code{paws} client.}
}
\value{
S3FileSystem class invisible
}
\description{
This creates a file system "like" API based off \code{fs}
(e.g. dir_ls, file_copy, etc.) for AWS S3 storage. To set up \code{AWS}
credentials please look at
\url{https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-files.html}
}
\examples{
\dontrun{
# Require AWS S3 credentials

# Set up connection using profile
s3_file_system(profile_name = "s3fs_example")

# Reset connection to connect to a different region
s3_file_system(
    profile_name = "s3fs_example",
    region_name = "us-east-1",
    refresh = TRUE
 )
}
}
