% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectrum.R
\name{Spectrum}
\alias{Spectrum}
\title{Estimate frequency spectrum}
\usage{
Spectrum(data, time_dim = "ftime", conf.lev = 0.95, ncores = NULL)
}
\arguments{
\item{data}{A vector or numeric array of which the frequency spectrum is 
required. If it's a vector, it should be a time series. If it's an array,
the  dimensions must have at least 'time_dim'. The data is assumed to be  
evenly spaced in time.}

\item{time_dim}{A character string indicating the dimension along which to 
compute the frequency spectrum. The default value is 'ftime'.}

\item{conf.lev}{A numeric indicating the confidence level for the Monte-Carlo
significance test. The default value is 0.95.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A numeric array of the frequency spectrum with dimensions 
 c(<time_dim> = number of frequencies, stats = 3, the rest of the 
 dimensions of 'data'). The 'stats' dimension contains the frequency values,
 the spectral density, and the confidence interval.
}
\description{
Estimate the frequency spectrum of the data array together with a 
user-specified confidence level. The output is provided as an array with 
dimensions c(number of frequencies, stats = 3, other margin dimensions of 
data). The 'stats' dimension contains the frequencies at which the spectral 
density is estimated, the estimates of the spectral density, and the 
significance level.\cr
The spectrum estimation relies on an R built-in function \code{spectrum()} 
and the confidence interval is estimated by the Monte-Carlo method.
}
\examples{
# Load sample data as in Load() example:
example(Load)
ensmod <- MeanDims(sampleData$mod, 2)
spectrum <- Spectrum(ensmod)

for (jsdate in 1:dim(spectrum)['sdate']) {
 for (jlen in 1:dim(spectrum)['ftime']) {
   if (spectrum[jlen, 2, 1, jsdate] > spectrum[jlen, 3, 1, jsdate]) {
     ensmod[1, jsdate, ] <- Filter(ensmod[1, jsdate, ], spectrum[jlen, 1, 1, jsdate])
   }
 }
}
 \donttest{
PlotAno(InsertDim(ensmod, 2, 1), sdates = startDates)
 }

}
