% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Corr.R
\name{Corr}
\alias{Corr}
\title{Compute the correlation coefficient between an array of forecast and their corresponding observation}
\usage{
Corr(exp, obs, time_dim = "sdate", dat_dim = "dataset", comp_dim = NULL,
  limits = NULL, method = "pearson", pval = TRUE, conf = TRUE,
  conf.lev = 0.95, ncores = NULL)
}
\arguments{
\item{exp}{A named numeric array of experimental data, with at least two 
dimensions 'time_dim' and 'dat_dim'.}

\item{obs}{A named numeric array of observational data, same dimensions as
parameter 'exp' except along dat_dim.}

\item{time_dim}{A character string indicating the name of dimension along
which the correlations are computed. The default value is 'sdate'.}

\item{dat_dim}{A character string indicating the name of dataset (nobs/nexp) 
dimension. The default value is 'dataset'.}

\item{comp_dim}{A character string indicating the name of dimension along which
obs is taken into account only if it is complete. The default value
is NULL.}

\item{limits}{A vector of two integers indicating the range along comp_dim to 
be completed. The default is c(1, length(comp_dim dimension)).}

\item{method}{A character string indicating the type of correlation: 
'pearson', 'spearman', or 'kendall'. The default value is 'pearson'.}

\item{pval}{A logical value indicating whether to compute or not the p-value 
of the test Ho: Corr = 0. The default value is TRUE.}

\item{conf}{A logical value indicating whether to retrieve the confidence 
intervals or not. The default value is TRUE.}

\item{conf.lev}{A numeric indicating the confidence level for the 
regression computation. The default value is 0.95.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A list containing the numeric arrays with dimension:\cr 
 c(nexp, nobs, all other dimensions of exp except time_dim).\cr
nexp is the number of experiment (i.e., dat_dim in exp), and nobs is the 
number of observation (i.e., dat_dim in obs).\cr
\item{$corr}{
 The correlation coefficient. 
}
\item{$p.val}{
 The p-value. Only present if \code{pval = TRUE}.
}
\item{$conf.lower}{
 The lower confidence interval. Only present if \code{conf = TRUE}.
}
\item{$conf.upper}{
 The upper confidence interval. Only present if \code{conf = TRUE}.
}
}
\description{
Calculate the correlation coefficient (Pearson, Kendall or Spearman) for 
an array of forecast and an array of observation. The correlations are 
computed along time_dim, the startdate dimension. If comp_dim is given, 
the correlations are computed only if obs along the comp_dim dimension are 
complete between limits[1] and limits[2], i.e., there is no NA between 
limits[1] and limits[2]. This option can be activated if the user wants to 
account only for the forecasts which the corresponding observations are 
available at all leadtimes.\cr 
The confidence interval is computed by the Fisher transformation and the 
significance level relies on an one-sided student-T distribution.\cr 
If the dataset has more than one member, ensemble mean is necessary necessary
before using this function since it only allows one dimension 'dat_dim' to
have inconsistent length between 'exp' and 'obs'. If all the dimensions of
'exp' and 'obs' are identical, you can simply use apply() and cor() to 
compute the correlation.
}
\examples{
# Load sample data as in Load() example: 
example(Load) 
clim <- Clim(sampleData$mod, sampleData$obs) 
corr <- Corr(clim$clim_exp, clim$clim_obs, time_dim = 'ftime', dat_dim = 'member')
# Renew the example when Ano and Smoothing is ready

}

