% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2-latlng.R
\name{s2_latlng}
\alias{s2_latlng}
\alias{as_s2_latlng}
\alias{as_s2_latlng.s2_latlng}
\alias{as_s2_latlng.s2_point}
\alias{as_s2_latlng.s2_geography}
\alias{as_s2_latlng.matrix}
\alias{as.data.frame.s2_latlng}
\alias{as.matrix.s2_latlng}
\title{Create an S2 LatLng Vector}
\usage{
s2_latlng(lat, lng)

as_s2_latlng(x, ...)

\method{as_s2_latlng}{s2_latlng}(x, ...)

\method{as_s2_latlng}{s2_point}(x, ...)

\method{as_s2_latlng}{s2_geography}(x, ...)

\method{as_s2_latlng}{matrix}(x, ...)

\method{as.data.frame}{s2_latlng}(x, ...)

\method{as.matrix}{s2_latlng}(x, ...)
}
\arguments{
\item{lat, lng}{Vectors of latitude and longitude values in degrees.}

\item{x}{A \code{\link[=s2_latlng]{s2_latlng()}} vector or an object that can be coerced to one.}

\item{...}{Unused}
}
\value{
An object with class s2_latlng
}
\description{
This class represents a latitude and longitude on the Earth's surface.
Most calculations in S2 convert this to a \code{\link[=as_s2_point]{as_s2_point()}}, which is a
unit vector representation of this value.
}
\examples{
s2_latlng(45, -64) # Halifax, Nova Scotia!
as.data.frame(s2_latlng(45, -64))

}
