\name{mapByRegion}
\alias{mapByRegion}
\title{Produce maps of regional level data from country level data}
\description{
This function will produce maps of regional statistics by aggregating country level data.
For example mapping the total population of Asia, Europe,etc, from country level population data.
As well as sums, other functions can be used, like mean, median, min, max, etc.
There are currently 8 choices of region and 4 choices of country code.
}
\usage{
mapByRegion(inFile, nameDataColumn, joinCode,
nameJoinColumn, regionType, FUN = 'mean', na.rm=TRUE, mapTitle = '', ...)
}
\arguments{
  \item{inFile}{a data frame}
  \item{nameDataColumn}{The name of a column of inFile. This is data is aggregated by FUN}
  \item{joinCode}{The type of code to join with. Must be one of: "ISO2", "ISO3", "Numeric" or "FIPS"}
  \item{nameJoinColumn}{The name of a column of inFile. Contains joining codes.}
  \item{regionType}{Must be one of: "GEO3", "GEO3major", "IMAGE24", "GLOCAF", "Stern", "SRES", "SRESmajor","GBD","AVOIDname"}
  \item{FUN}{A function to apply to each region}
  \item{na.rm}{Only used for certain values of FUN. See details section below.}
  \item{mapTitle}{a title to be printed above the map}
  \item{\dots}{further arguments to be passed to \code{\link{mapCountryData}}}
}
\details{
The function is very similar to country2Region. The first difference is that the output is a map, rather than statistics. The second is the behaviour of extra arguments.
In country2Region the extra arguments go to FUN, here they go to mapCountryData.

The na.rm argument is used when FUN has one of the following values:
"mean","min","max","median","range","var","sd","mad" or "IQR".
This reduces the problem of not being able to supply extra arguments to FUN.
}
\value{
invisibly returns a list containing the data and main options used for the map, 
the list can be passed to \code{\link{addMapLegend}} along with additional options
to allow greater flexibility in legend creation.
}
\seealso{An alternative tool to \code{\link{country2Region}}. The plotting is done by \code{\link{mapCountryData}}}
\examples{
data(countryExData)

mapByRegion(inFile=countryExData
		        ,nameDataColumn="CLIMATE"
		        ,joinCode="ISO3"
		        ,nameJoinColumn="ISO3V10"
		        ,regionType="Stern"
	         	,FUN='mean'
	         	)

}
\keyword{hplot}

