% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_authors.R
\name{construct_authors}
\alias{construct_authors}
\title{Construct authors}
\usage{
construct_authors(
  authors = NULL,
  template = c(utils::person(given = "yourGivenName", family = "yourFamilyName", role =
    c("cre"), email = "yourEmail@email.com", comment = c(ORCID = "yourOrcidId")))
)
}
\arguments{
\item{authors}{A list of authors who contributed to your R package,
 each provided as objects of class \link[utils]{person}.
By default, if an \code{Authors} field already exists in the 
\emph{DESCRIPTION} file, the original values are kept.
Otherwise, a template \link[utils]{person} list is created using the 
\link[rworkflows]{construct_authors}.}

\item{template}{Default value to return when \code{authors=NULL}.}
}
\value{
Named list in \link[utils]{person} format.
}
\description{
Helper function to construct an author list for a \emph{DESCRIPTION} file.
Returns a template when \code{authors} is not provided (default).
}
\examples{
authors <- construct_authors()
}
