% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/rwirelesscom.R
\name{f16qamdemod}
\alias{f16qamdemod}
\title{16 QAM Demodulator}
\usage{
f16qamdemod(r)
}
\arguments{
\item{r}{- vector of complex vector}
}
\value{
a vector of 1's and 0's, 4 bits per input element (16-QAM symbol)
}
\description{
Receives a vector of complex values, r, corresponding to a
16-QAM modulated signal transmitted through a communications channel
(e.g., signal plus noise). Each received 16-QAM symbol (one symbol per r sample) is decoded into
4 bits. The 16-QAM symbol decision regions are defined with respect to
the constellation generated by f16qammod(), where in-phase and quadrature
constellation points take on values -3, -1, +1, +3, respectively.
}
\examples{
M=16
Es=10
Eb = Es/log2(M)
Nsymbols=100
Nbits=log2(M)*Nsymbols
bits <- sample(0:1,Nbits, replace=TRUE)
s <- f16qammod(bits)
EbNodB=8
No = Eb/(10^(EbNodB/10))
n <- fNo(Nsymbols,No,type="complex")
r <- s+n
bitsr <- f16qamdemod(r)
biterrs<-bits[bitsr!=bits]
Pberr=length(biterrs)/length(bits)
}
\seealso{
Other modulation.demodulation.communications: \code{\link{f16pskdemod}};
  \code{\link{f16pskmod}}; \code{\link{f16qammod}};
  \code{\link{f64qamdemod}}; \code{\link{f64qammod}};
  \code{\link{f8pskdemod}}; \code{\link{f8pskmod}};
  \code{\link{fNo}}; \code{\link{fbpskdemod}};
  \code{\link{fbpskmod}}; \code{\link{fqpskdemod}};
  \code{\link{fqpskmod}}; \code{\link{iqdensityplot}};
  \code{\link{iqscatterplot}}
}

