% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w_structure.R
\name{w_structure}
\alias{w_structure}
\title{Get the structure of a dataset}
\usage{
w_structure(dataset_name, language = "fr", option = "light", client_ID,
  base_url = "https://api.webstat.banque-france.fr/webstat-")
}
\arguments{
\item{dataset_name}{Mandatory. String (must be entered between quotes.) The datasets codes can be determined using the w_datasets() function.}

\item{language}{Optional. String. Defaults to "fr" (French). The only other available option is "en" (English). Determines the language of the metadata. Your Webstat "App" must be subscribed to the API in this language or you'll get a 501 http error.}

\item{option}{Optional. 'light' or 'full'}

\item{client_ID}{Optional. String. If you do not specify it when calling the function, it will check if a global variable called "webstat_client_ID" exists and use it. If not, you will be prompted. The easiest way is to save the client ID as a string in a "webstat_client_ID" global variable.}

\item{base_url}{Optional. String. Defaults to "https://api.webstat.banque-france.fr/webstat-". For internal testing purposes only.}
}
\value{
a list of dataset structure
}
\description{
Get the structure of a dataset
}
\examples{
\dontrun{
w_structure("EXR")
}

}
