% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{window_run}
\alias{window_run}
\title{List of running windows}
\usage{
window_run(
  x,
  k = integer(0),
  lag = integer(1),
  idx = integer(0),
  at = integer(0),
  na_pad = FALSE
)
}
\arguments{
\item{x}{(\code{vector}, \code{data.frame}, \code{matrix}, \code{xts}, \code{grouped_df})\cr
Input in runner custom function \code{f}.}

\item{k}{(\code{integer} vector or single value)\cr
Denoting size of the running window. If \code{k} is a single value then window
size is constant for all elements, otherwise if \code{length(k) == length(x)}
different window size for each element. One can also specify \code{k} in the same
way as \code{by} argument in \code{\link[base]{seq.POSIXt}}.
See 'Specifying time-intervals' in details section.}

\item{lag}{(\code{integer} vector or single value)\cr
Denoting window lag. If \code{lag} is a single value then window lag is constant
for all elements, otherwise if \code{length(lag) == length(x)} different window
size for each element. Negative value shifts window forward. One can also
specify \code{lag} in the same way as \code{by} argument in
\code{\link[base]{seq.POSIXt}}. See 'Specifying time-intervals' in details
section.}

\item{idx}{(\code{integer}, \code{Date}, \code{POSIXt})\cr
Optional integer vector containing sorted (ascending) index of observation.
By default \code{idx} is index incremented by one. User can provide index with
varying increment and with duplicated values. If specified then \code{k} and
\code{lag} are depending on \code{idx}. Length of \code{idx} have to be equal of length
\code{x}.}

\item{at}{(\code{integer}, \code{Date}, \code{POSIXt}, \code{character} vector)\cr
Vector of any size and any value defining output data points. Values of the
vector defines the indexes which data is computed at. Can be also \code{POSIXt}
sequence increment used in \code{at} argument in \code{\link[base]{seq.POSIXt}}.
See 'Specifying time-intervals' in details section.}

\item{na_pad}{(\code{logical} single value)\cr
Whether incomplete window should return \code{NA} (if \code{na_pad = TRUE})
Incomplete window is when some parts of the window are out of range.}
}
\value{
list of vectors (windows). Length of list is the same as
\code{length(x)} or \code{length(at)} if specified, and length of each
window is defined by \code{k} (unless window is out of range).
}
\description{
Creates \code{list} of windows with given arguments settings.
Length of output \code{list} is equal
}
\examples{
window_run(1:10, k = 3, lag = -1)
window_run(letters[1:10], k = c(1, 2, 2, 4, 5, 5, 5, 5, 5, 5))
}
