% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{whichd_run}
\alias{whichd_run}
\title{Index of previous, different element}
\usage{
whichd_run(x, k = 0L, na_pad = FALSE)
}
\arguments{
\item{x}{vector of any type where running index is calculated}

\item{k}{running window size. By default window size equals \code{length(x)}. Allow varying window size specified by vector of \code{length(x)}}

\item{na_pad}{logical (default \code{na_pad=FALSE}) - if \code{TRUE} first k-results will be filled by \code{NA}. If k is not specified na_pad=F by default.}
}
\value{
numeric vector of length equals length of \code{x} containing running index length in \code{k}-long window.
}
\description{
Index of previous element different than current
}
\examples{
set.seed(11)
x1 <- sample(c("a","b"),15,replace=TRUE)
x2 <- sample(c(NA_character_,"a","b"),15,replace=TRUE)
k  <- sample(1:4,15,replace=TRUE)
whichd_run(x1)
whichd_run(x1, k=2)
whichd_run(x2, na_pad=TRUE, k=3)
whichd_run(x1, k=k)
}
