% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spread-groups.R
\name{spread_groups}
\alias{spread_groups}
\title{Spread grouping columns}
\usage{
spread_groups(.tbl, ..., .group_sep = ".", .col_sep = "._.")
}
\arguments{
\item{.tbl}{Data frame with result of grouped summary.}

\item{...}{A selection of grouping columns (as in \code{\link[tidyr:unite]{tidyr::unite()}}).}

\item{.group_sep}{A string to be used as separator of grouping levels.}

\item{.col_sep}{A string to be used as separator in column pack.}
}
\value{
A data frame in \link[=column-pack]{column pack} format.
}
\description{
Function that is used during interpretation of \link[=group-pack]{group pack}
output. It converts grouped \link[dplyr:summarise]{summary} into \link[=column-pack]{column pack} format.
}
\details{
Multiple grouping variables are converted to one with
\code{\link[tidyr:unite]{tidyr::unite()}} and separator \code{.group_sep}. New values are then treated as
variable names which should be validated and which represent the group data
as a whole.
}
\examples{
mtcars_grouped_summary <- mtcars \%>\%
  dplyr::group_by(vs, am) \%>\%
  dplyr::summarise(n_low = dplyr::n() > 6, n_high = dplyr::n() < 10)

spread_groups(mtcars_grouped_summary, vs, am)

spread_groups(mtcars_grouped_summary, vs, am, .group_sep = "__")

spread_groups(mtcars_grouped_summary, vs, am, .col_sep = "__")

}
