% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtsplot.r
\name{rtsplot.lines}
\alias{rtsplot.lines}
\title{Add lines to time series plot}
\usage{
rtsplot.lines(y, type = "l", col = graphics::par("col"), ...)
}
\arguments{
\item{y}{\code{\link{xts}} object}

\item{type}{line type, \strong{defaults to 'l'}, for more info see \code{\link{lines}}}

\item{col}{color, \strong{defaults to par('col')}}

\item{...}{additional parameters to the \code{\link{lines}}}
}
\value{
nothing
}
\description{
Add lines to time series plot
}
\examples{
y = rtsplot.fake.stock.data(1000)
symbol = 'SPY'
	
 # moving average
sma = TTR::SMA(y, 250)

 # plot
 layout(1)
 rtsplot(y, type = 'l', col='black')
 rtsplot.lines(sma, col='blue', lwd=1.5)
rtsplot.legend(c(symbol, 'SMA(250)'), 'black,blue', list(y,sma))

}
