% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_outer.R
\name{rtry_join_outer}
\alias{rtry_join_outer}
\title{Outer join for two data frames}
\usage{
rtry_join_outer(x, y, baseOn, showOverview = TRUE)
}
\arguments{
\item{x}{A data frame or data table to be coerced and will be considered as the data on the left.}

\item{y}{A data frame or data table to be coerced and will be considered as the data on the right.}

\item{baseOn}{The common column used for merging.}

\item{showOverview}{Default \code{TRUE} displays the dimension and column names of the merged data.}
}
\value{
An object of the same type of the input data. The merged data is by default lexicographically sorted
on the common column. The columns are the common column followed by the remaining columns in
\code{x} and then those in \code{y}.
}
\description{
This function merges two data frames or data tables based on a specified common column and
returns all rows from both data, join records from the left (\code{x}) which have matching
keys in the right data frame (\code{y}). In order words, this functions performs an outer
join on the two provided data frames, i.e. the join table will contain all records from
both data frames or data tables.
}
\examples{
# Assume a user has obtained two unique data tables, one with the ancillary data
# Longitude and one with Latitude (e.g. using rtry_select_anc()), and would like to
# merge two data tables into one according to the common identifier ObservationID.
# It does not matter if either Longitude or Latitude data has no record
lon <- rtry_select_anc(data_TRY_15160, 60)
lat <- rtry_select_anc(data_TRY_15160, 59)

georef <- rtry_join_outer(lon, lat, baseOn = ObservationID)

# Expected messages:
# dim:   97 2
# col:   ObservationID Longitude
#
# dim:   98 2
# col:   ObservationID Latitude
#
# dim:   98 3
# col:   ObservationID Longitude Latitude
}
\references{
This function makes use of the \code{\link[base]{merge}} function
within the \code{base} package.
}
\seealso{
\code{\link{rtry_join_left}}, \code{\link{rtry_bind_col}}, \code{\link{rtry_bind_row}}
}
