% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_post.R
\name{coef.trim}
\alias{coef.trim}
\title{Extract TRIM model coefficients.}
\usage{
\method{coef}{trim}(object, representation = c("standard", "trend",
  "deviations"), ...)
}
\arguments{
\item{object}{TRIM output structure (i.e., output of a call to \code{trim})}

\item{representation}{\code{[character]} Choose the coefficient
representation. Options \code{"trend"} and \code{"deviations"} are for model 3 only.}

\item{...}{currently unused}
}
\value{
A \code{data.frame} containing coefficients and their standard errors,
both in additive and multiplicative form.
}
\description{
Extract TRIM model coefficients.
}
\section{Details}{


Extract the site, growth or time effect parameters computed with
\code{\link{trim}}.
}

\section{Additive versus multiplicative representation}{


In the simplest cases (no covariates, no change points), the trim
Model 2 and Model 3 can be summarized as follows:

\itemize{
\item{Model 2: \eqn{\ln\mu_{ij}=\alpha_i + \beta\times(j-1)} }
\item{Model 3: \eqn{\ln\mu_{ij}=\alpha_i + \gamma_j}.}
}

Here, \eqn{\mu_{ij}} is the estimated number of counts at site \eqn{i}, time
\eqn{j}. The parameters \eqn{\alpha_i}, \eqn{\beta} and \eqn{\gamma_j} are
refererred to as coefficients in the additive representation. By
exponentiating both sides of the above equations, alternative representations
can be written down. Explicitly, one can show that

\itemize{
\item{Model 2: \eqn{\mu_{ij}= a_ib^{(j-1)} = b\mu_{ij-1}}, where \eqn{a_i=e^{\alpha_i}} and \eqn{b=e^\beta}.}
\item{Model 3: \eqn{\mu_{ij}=a_ic_j}, where \eqn{a_i=e^{\alpha_i}}, \eqn{c_1=1} and \eqn{c_j=e^{\gamma_j}} for \eqn{j>1}.}
}

The parameters \eqn{a_i}, \eqn{b} and \eqn{c_j} are referred to as
coefficients in the \emph{multiplicative form}.
}

\section{Trend and deviation (Model 3 only)}{


The equation for Model 3

\eqn{\ln\mu_{ij}  = \alpha_i + \gamma_j},

can also be written as an overall slope resulting from a linear regression of
the \eqn{\mu_{ij}} over time,  plus site- and time effects that
record deviations from this overall slope.  In such a reparametrisation
the previous equation can be written as

\eqn{\ln\mu_{ij} = \alpha_i^* + \beta^*d_j + \gamma_j^*,}

where \eqn{d_j} equals \eqn{j} minus the mean over all \eqn{j} (i.e. if \eqn{j=1,2,\ldots,J}
then \eqn{d_j = j-(J+1)/2}). It is not hard to show that
\itemize{
\item{The \eqn{\alpha_i^*} are the mean \eqn{\ln\mu_{ij}} per site}
\item{The \eqn{\gamma_j^*} must sum to zero.}
}
The coefficients \eqn{\alpha_i^*} and \eqn{\gamma_j^*} are obtained by
setting \code{representation="deviations"}. If \code{representation="trend"},
the overall trend parameters \eqn{\beta^*} and \eqn{\alpha^*} from the overall
slope defined by \eqn{\alpha^* + \beta^*d_j} is returned.

Finally, note that both the overall slope and the deviations can be written
in multiplicative form as well.
}

\examples{
data(skylark)
z <- trim(count ~ site + time, data=skylark, model=2, overdisp=TRUE)
coefficients(z)
}
\seealso{
Other analyses: \code{\link{confint.trim}},
  \code{\link{gof}}, \code{\link{index}},
  \code{\link{now_what}}, \code{\link{overall}},
  \code{\link{overdispersion}},
  \code{\link{plot.trim.index}},
  \code{\link{plot.trim.overall}}, \code{\link{results}},
  \code{\link{serial_correlation}},
  \code{\link{summary.trim}}, \code{\link{totals}},
  \code{\link{trim}}, \code{\link{vcov.trim}},
  \code{\link{wald}}
}
\concept{analyses}
