% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setupDataset.R
\name{setupDataset}
\alias{setupDataset}
\title{Setup datasets loaded from the living conditions survey}
\usage{
setupDataset(dataset, country = "ES", region = "all", s = "OECD",
  deflac = NULL, ppp = FALSE)
}
\arguments{
\item{dataset}{a data.frame containing variables in the EU-SILC microdata format.}

\item{country}{a character string specifying the country whose data will be considered.}

\item{region}{a character string specifying the region of the country whose data will be considered.}

\item{s}{either a character string or a numeric value between 0 and 1 specifying the equivalence scale to be used to obtain the equivalized disposable income. The default ("OECD") considers the standar modified OECD scale.}

\item{deflac}{numeric; a number to be used as a deflator. The default (NULL) will not apply any deflation.}

\item{ppp}{a logical; if it is TRUE the purchasing power parity (PPP) exchange rate will be used.}
}
\value{
A data.frame with the following variables:
\itemize{
 \item DB010 a numeric vector containing the year of the survey.
 \item DB020 a factor with one level which is the country considered.
 \item DB040 a factor with as many levels as there are regions in the country.
 \item DB090 a numeric vector containing information about household cross-sectional weight.
 \item HX040 an integer vector containing information about households size.
 \item HX050 a numeric vector containing information about the equivalised household size. The scale employed is the modified OECD scale.
 \item HX090 a numeric vector containing information about equivalised disposable income (with the modified OECD scale).
 \item ipuc a numeric vector containing the income per unit of consumption. This variable takes into account if deflac is not NULL, ppp is TRUE or/and the value assigned to \emph{s}.
 \item wHX040 a numeric vector which is obtained by multiplying DB090 by HX040. It represents household weights taking into account the size of the household.
}
}
\description{
Extracts and transforms variables taken directly from the EU-SILC survey.
}
\details{
We obtain the equivalized disposable income with the equivalence
scale of Buhmann et al. (1988) by assigning a numeric value between 0 and 1
to argument s . The parameter s is called elasticity of equivalence.

The purchasing power parity exchange rate is useful for making comparisons between countries.
}
\examples{
data(eusilc2)
ATdataset <- setupDataset(eusilc2, country = "AT")
str(ATdataset)

}
\author{
A. Berihuete, C.D. Ramos and M.A. Sordo
}
\references{
B. Buhmann et al. (1988) Equivalence scales, well-being, inequality and poverty: sensitivity estimates across ten countries using the Luxembourg Income Study (LIS) database, Review of Income and Wealth, 34, 115--142.
}
\seealso{
loadEUSILC, loadLCS
}

