% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mip.R
\name{mip}
\alias{mip}
\title{Mean income per person}
\usage{
mip(dataset, ci = FALSE, rep = 1000, verbose = FALSE)
}
\arguments{
\item{dataset}{a data.frame containing variables obtained by using the setupDataset function.}

\item{ci}{logical; if  TRUE, 95 percent confidence interval is given for the mean income per unit of consumption.}

\item{rep}{a number to make the confidence interval using boostrap technique.}

\item{verbose}{logical; if TRUE the confindence interval is plotted.}
}
\value{
The value of mean income per person.
}
\description{
Estimates the mean income per person.
}
\examples{
data(eusilc2)
ATdataset <- setupDataset(eusilc2, country = "AT", s = "OECD")
mip(ATdataset)

}
\author{
A. Berihuete, C.D. Ramos and M.A. Sordo
}
\references{
B. Buhmann et al. (1988) Equivalence scales, well-being, inequality and poverty: sensitivity estimates across ten countries using the Luxembourg Income Study (LIS) database, Review of Income and Wealth, 34, 115--142.

\url{http://ec.europa.eu/eurostat/statistics-explained/index.php/Glossary:Equivalised_disposable_income}
}
\seealso{
setupDataset.
}

