% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_rcell.R
\name{format_rcell}
\alias{format_rcell}
\title{Format \code{rcell} objects}
\usage{
format_rcell(
  x,
  format,
  output = c("ascii", "html"),
  na_str = obj_na_str(x) \%||\% "NA",
  pr_row_format = NULL,
  pr_row_na_str = NULL,
  shell = FALSE
)
}
\arguments{
\item{x}{(\code{CellValue} or \code{ANY})\cr an object of class \code{CellValue}, or a raw value.}

\item{format}{(\code{string} or \code{function})\cr the format label or formatter function to
apply to \code{x}.}

\item{output}{(\code{string})\cr output type.}

\item{na_str}{(\code{string})\cr string that should be displayed when the value of \code{x} is missing. Defaults to \code{"NA"}.}

\item{pr_row_format}{(\code{list})\cr list of default formats coming from the general row.}

\item{pr_row_na_str}{(\code{list})\cr list of default \code{"NA"} strings coming from the general row.}

\item{shell}{(\code{flag})\cr whether the formats themselves should be returned instead of the
values with formats applied. Defaults to \code{FALSE}.}
}
\value{
Formatted text.
}
\description{
This is a wrapper for \code{\link[formatters:format_value]{formatters::format_value()}} for use with \code{CellValue} objects
}
\examples{
cll <- CellValue(pi, format = "xx.xxx")
format_rcell(cll)

# Cell values precedes the row values
cll <- CellValue(pi, format = "xx.xxx")
format_rcell(cll, pr_row_format = "xx.x")

# Similarly for NA values
cll <- CellValue(NA, format = "xx.xxx", format_na_str = "This is THE NA")
format_rcell(cll, pr_row_na_str = "This is NA")

}
