% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_funs.R
\docType{data}
\name{select_all_levels}
\alias{select_all_levels}
\alias{add_combo_levels}
\title{Add Combination Levels to split}
\format{
An object of class \code{AllLevelsSentinel} of length 0.
}
\usage{
select_all_levels

add_combo_levels(combosdf, trim = FALSE, first = FALSE, keep_levels = NULL)
}
\arguments{
\item{combosdf}{\code{data.frame}/\code{tbl_df}. Columns \code{valname}, \code{label}, \code{levelcombo},
\code{exargs}. Of which \code{levelcombo} and \code{exargs} are list columns. Passing the
\code{select_all_levels} object as a value in the \code{comblevels} column
indicates that an overall/all-observations level should be created.}

\item{trim}{logical(1). Should splits corresponding with 0 observations be
kept when tabulating.}

\item{first}{logical(1). Should the created split level be placed first in
the levels (\code{TRUE}) or last (\code{FALSE}, the default).}

\item{keep_levels}{character or NULL. If non-NULL, the levels to retain
across both combination and individual levels.}
}
\value{
a closure suitable for use as a splitting function (\code{splfun})
when creating a table layout
}
\description{
Add Combination Levels to split
}
\note{
Analysis or summary functions for which the order matters should never
be used within the tabulation framework.
}
\examples{
library(tibble)
combodf <- tribble(
  ~valname, ~label, ~levelcombo, ~exargs,
  "A_B", "Arms A+B", c("A: Drug X", "B: Placebo"), list(),
  "A_C", "Arms A+C", c("A: Drug X", "C: Combination"), list()
)

lyt <- basic_table(show_colcounts = TRUE) \%>\%
  split_cols_by("ARM", split_fun = add_combo_levels(combodf)) \%>\%
  analyze("AGE")

tbl <- build_table(lyt, DM)
tbl

lyt1 <- basic_table(show_colcounts = TRUE) \%>\%
  split_cols_by("ARM",
    split_fun = add_combo_levels(combodf,
      keep_levels = c(
        "A_B",
        "A_C"
      )
    )
  ) \%>\%
  analyze("AGE")

tbl1 <- build_table(lyt1, DM)
tbl1

smallerDM <- droplevels(subset(DM, SEX \%in\% c("M", "F") &
  grepl("^(A|B)", ARM)))
lyt2 <- basic_table(show_colcounts = TRUE) \%>\%
  split_cols_by("ARM", split_fun = add_combo_levels(combodf[1, ])) \%>\%
  split_cols_by("SEX",
    split_fun = add_overall_level("SEX_ALL", "All Genders")
  ) \%>\%
  analyze("AGE")

lyt3 <- basic_table(show_colcounts = TRUE) \%>\%
  split_cols_by("ARM", split_fun = add_combo_levels(combodf)) \%>\%
  split_rows_by("SEX",
    split_fun = add_overall_level("SEX_ALL", "All Genders")
  ) \%>\%
  summarize_row_groups() \%>\%
  analyze("AGE")

tbl3 <- build_table(lyt3, smallerDM)
tbl3
}
\keyword{datasets}
