% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name.R
\name{name}
\alias{name}
\alias{name,character-method}
\alias{name,SsimLibrary-method}
\alias{name,Scenario-method}
\alias{name,Project-method}
\alias{name,Folder-method}
\alias{name,Chart-method}
\alias{name<-}
\alias{name<-,character-method}
\alias{name<-,SsimLibrary-method}
\alias{name<-,Project-method}
\alias{name<-,Scenario-method}
\alias{name<-,Folder-method}
\alias{name<-,Chart-method}
\title{Name of a SsimLibrary, Project, Scenario, Folder, or Chart}
\usage{
name(ssimObject)

\S4method{name}{character}(ssimObject)

\S4method{name}{SsimLibrary}(ssimObject)

\S4method{name}{Scenario}(ssimObject)

\S4method{name}{Project}(ssimObject)

\S4method{name}{Folder}(ssimObject)

\S4method{name}{Chart}(ssimObject)

name(ssimObject) <- value

\S4method{name}{character}(ssimObject) <- value

\S4method{name}{SsimLibrary}(ssimObject) <- value

\S4method{name}{Project}(ssimObject) <- value

\S4method{name}{Scenario}(ssimObject) <- value

\S4method{name}{Folder}(ssimObject) <- value

\S4method{name}{Chart}(ssimObject) <- value
}
\arguments{
\item{ssimObject}{\code{\link{Scenario}}, \code{\link{Project}},
\code{\link{SsimLibrary}}, \code{\link{Folder}} or \code{\link{Chart}} object}

\item{value}{character string of the new name}
}
\value{
A character string: the name of the SsimObject.
}
\description{
Retrieves or sets the name of a \code{\link{SsimLibrary}},
\code{\link{Project}}, \code{\link{Scenario}}, or \code{\link{Folder}}.
}
\examples{
\dontrun{
# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib")

# Set up a SyncroSim Session, SsimLibrary, Project, and Scenario
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, 
                         session = mySession,
                         packages = "stsim")
myProject <- project(myLibrary, project = "Definitions")
myScenario <- scenario(myProject, scenario = "My Scenario")
myFolder <- folder(myProject, folder = "New Folder")
myChart <- chart(myProject, chart = "New Chart")

# Retrieve names of the SsimObjects
name(myLibrary)
name(myProject)
name(myScenario)
name(myFolder)
name(myChart)

# Set the name of the SyncroSim Scenario
name(myScenario) <- "My Scenario Name"
}

}
