% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqb.R
\name{rqb}
\alias{rqb}
\title{Randomized QB Decomposition (rqb).}
\usage{
rqb(A, k = NULL, p = 10, q = 2, sdist = "normal", rand = TRUE)
}
\arguments{
\item{A}{array_like; \cr
real/complex \eqn{(m, n)} input matrix (or data frame).}

\item{k}{integer, optional; \cr
target rank of the low-rank decomposition. It should satisfy \eqn{k << min(m,n)}.}

\item{p}{integer, optional; \cr
oversampling parameter (default \eqn{p=10}).}

\item{q}{integer, optional; \cr
number of power iterations (default \eqn{q=2}).}

\item{sdist}{string \eqn{c( 'unif', 'normal', 'rademacher')}, optional; \cr
specifies the sampling distribution: \cr
\eqn{'unif'} :  Uniform `[-1,1]`. \cr
\eqn{'normal}' (default) : Normal `~N(0,1)`. \cr
\eqn{'rademacher'} : Rademacher random variates. \cr}

\item{rand}{bool, optional; \cr
If (\eqn{TRUE}), a probabilistic strategy is used, otherwise a deterministic algorithm is used.}
}
\value{
\code{rqb} returns a list containing the following components:
\item{Q}{  array_like; \cr
          matrix with orthogonal columns; \eqn{(m, k)} dimensional array.
}

\item{B}{  array_like; \cr
          smaller matrix; \eqn{(k, n)} dimensional array.
}

\itemize{
 \item [1] N. B. Erichson, S. Voronin, S. L. Brunton and J. N. Kutz. 2019.
       Randomized Matrix Decompositions Using {R}. 
       Journal of Statistical Software, 89(11), 1-48.
       \url{http://doi.org/10.18637/jss.v089.i11}.

  \item  [2] N. Halko, P. Martinsson, and J. Tropp.
         "Finding structure with randomness: probabilistic
         algorithms for constructing approximate matrix
         decompositions" (2009).
         (available at arXiv \url{http://arxiv.org/abs/0909.4061}).
}
}
\description{
Compute the near-optimal QB decomposition of a rectangular matrix.
}
\details{
The randomized QB decomposition factors a rectangular \eqn{(m,n)} matrix \eqn{A} as
\eqn{A = Q * B}. \eqn{Q} is an \eqn{(m,k)} matrix with orthogonal columns, and \eqn{B} a \eqn{(k,n)} matrix.
The target rank is assumed to be \eqn{k << min(m,n)}.   

\eqn{p} is an oversampling parameter to improve the approximation.
A value between 5 and 10 is recommended, and \eqn{p=10} is set by default.

The parameter \eqn{q} specifies the number of power (subspace) iterations
to reduce the approximation error. This is recommended
if the the singular values decay slowly. In practice 1 or 2 iterations
achieve good results, however, computing power iterations increases the
computational time. The number of power iterations is set to \eqn{q=2} by default.
}
\seealso{
\code{\link{svd}}
}
\author{
N. Benjamin Erichson, \email{erichson@berkeley.edu}
}
