% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scto_auth.R
\name{scto_auth}
\alias{scto_auth}
\title{Get a SurveyCTO authentication session object}
\usage{
scto_auth(
  auth_file = NULL,
  servername = NULL,
  username = NULL,
  password = NULL
)
}
\arguments{
\item{auth_file}{String indicating path to file containing authorization
information, which should have servername on the first line, username on
the second, and password on the third. If \code{auth_file} is not \code{NULL}, other
arguments are ignored. If \code{auth_file} is \code{NULL}, other arguments must be
provided.}

\item{servername}{String indicating name of the SurveyCTO server.}

\item{username}{String indicating username for the SurveyCTO account.}

\item{password}{String indicating password for the SurveyCTO account.}
}
\value{
\code{scto_auth} object for an authenticated SurveyCTO session.
}
\description{
Authenticates with SurveyCTO and fetches corresponding credentials.
}
\examples{
\dontrun{
# preferred approach, avoids storing any credentials in code
auth = scto_auth('scto_auth.txt')

# alternate approach
auth = scto_auth('my_server', 'my_user', 'my_pw', auth_file = NULL)
}

}
\seealso{
\code{\link[=scto_read]{scto_read()}}, \code{\link[=scto_get_attachments]{scto_get_attachments()}}, \code{\link[=scto_write]{scto_write()}}
}
