% Generated by roxygen2 (4.0.1): do not edit by hand
\name{cg_committees}
\alias{cg_committees}
\title{Gets details (subcommittees + membership) for a committee by id.}
\usage{
cg_committees(member_ids = NULL, committee_id = NULL, chamber = NULL,
  subcommittee = NULL, parent_committee_id = NULL, query = NULL,
  fields = NULL, page = 1, per_page = 20, order = NULL,
  key = getOption("SunlightLabsKey",
  stop("need an API key for Sunlight Labs")), return = "table", ...)
}
\arguments{
\item{member_ids}{An array of bioguide IDs of legislators that are assigned to this committee.}

\item{committee_id}{Official ID of the committee, as it appears in various official sources (Senate, House, and Library of Congress).}

\item{chamber}{The chamber this committee is part of. 'house', 'senate', or 'joint'.}

\item{subcommittee}{Whether or not the committee is a subcommittee.}

\item{parent_committee_id}{If the committee is a subcommittee, the ID of its parent committee.}

\item{fields}{You can request specific fields by supplying a vector of fields names. Many fields
are not returned unless requested. If you don't supply a fields parameter, you will get the
most commonly used subset of fields only. To save on bandwidth, parsing time, and confusion,
it's recommended to always specify which fields you will be using.}

\item{key}{your SunlightLabs API key; loads from .Rprofile}

\item{return}{(character) One of table (default), list, or response (httr response object).
When table is requested, the default, a table is not always returned, but is returned almost
always. You can then make a table yourself if you like.}

\item{...}{Optional additional curl options (debugging tools mostly). See examples.}

\item{page}{Page to return. Default: 1. You can use this in combination with the
per_page parameter to get more than the default or max number of results per page.}

\item{per_page}{Number of records to return. Default: 20. Max: 50.}

\item{order}{Sort results by one or more fields with the order parameter. order is
optional, but if no order is provided, the order of results is not guaranteed to be predictable.
Append \code{__asc} or \code{__desc} to the field names to control sort direction. The default
direction is \code{desc}, because it is expected most queries will sort by a date. Any field
which can be used for filtering may be used for sorting. On full-text search endpoints (URLs
ending in \code{/search}), you may sort by score to order by relevancy.}

\item{query}{(character) Return results the API thinks best match your query. Queries are
interpreted as phrases.}
}
\value{
Committee details including subcommittees and all members.
}
\description{
Names, IDs, contact info, and memberships of committees and subcommittees in the House and
Senate. All committee information is sourced from bulk data at github.com/unitedstates, which
in turn comes from official House and Senate sources . Feel free to open a ticket with any
bugs or suggestions. We only provide information on current committees and memberships. For
historic data on committee names, IDs, and contact info, refer to the bulk data.
}
\examples{
\dontrun{
cg_committees(member_ids='L000551')
cg_committees(committee_id='SSAP')
cg_committees(committee_id='SSAP', fields='members')
cg_committees(chamber='joint', subcommittee=FALSE)
cg_committees(parent_committee_id='HSWM')

# Disable pagination
cg_committees(per_page='all')

# Output a list
cg_committees(member_ids='L000551', return='list')
# Output an httr response object, for debugging purposes
cg_committees(member_ids='L000551', return='response')
}
}

