% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launcher-functions.R
\name{launcherSubmitJob}
\alias{launcherSubmitJob}
\title{Submit a Launcher Job}
\usage{
launcherSubmitJob(name, cluster = "Local", tags = NULL,
  command = NULL, exe = NULL, args = NULL, environment = NULL,
  stdin = NULL, stdoutFile = NULL, stderrFile = NULL,
  workingDirectory = NULL, host = NULL, container = NULL,
  exposedPorts = NULL, mounts = NULL, placementConstraints = NULL,
  resourceLimits = NULL, queues = NULL, config = NULL,
  user = Sys.getenv("USER"), applyConfigSettings = TRUE)
}
\arguments{
\item{name}{A descriptive name to assign to the job.}

\item{cluster}{The name of the cluster this job should be submitted to.}

\item{tags}{A set of user-defined tags, used for searching and querying
jobs.}

\item{command}{The command to run within the job. This is executed via the
system shell. Only one of command or exe should be specified.}

\item{exe}{The (fully pathed) executable to run within the job. Only one of
\code{command} or \code{exe} should be specified.}

\item{args}{An array of arguments to pass to the command / executable.}

\item{environment}{A list of environment variables to be set for processes
launched with this job.}

\item{stdin}{Data to be written to stdin when the job process is launched.}

\item{stdoutFile}{The file used for the job's generated standard output. Not
all launcher plugins support this parameter.}

\item{stderrFile}{The file used for the job's generated standard error. Not
all launcher plugins support this parameter.}

\item{workingDirectory}{The working directory to be used by the command /
executable associated with this job.}

\item{host}{The host that the job is running on, or the desired host during
job submission.}

\item{container}{The container to be used for launched jobs.}

\item{exposedPorts}{The ports that are exposed by services running on a
container. Only applicable to systems that support containers.}

\item{mounts}{A list of mount points. See \code{\link[=launcherHostMount]{launcherHostMount()}} and
\code{\link[=launcherNfsMount]{launcherNfsMount()}} for more information.}

\item{placementConstraints}{A list of placement constraints. See
\code{\link[=launcherPlacementConstraint]{launcherPlacementConstraint()}} for more information.}

\item{resourceLimits}{A list of resource limits. See \code{\link[=launcherResourceLimit]{launcherResourceLimit()}}
for more information.}

\item{queues}{A list of available submission queues for the cluster. Only
applicable to batch systems like LSF.}

\item{config}{A list of cluster-specific configuration options. See
\code{\link[=launcherConfig]{launcherConfig()}} for more information.}

\item{user}{The user-name of the job owner.}

\item{applyConfigSettings}{Apply server-configured mounts, exposedPorts, and
environment, in addition to any specified in this call.}
}
\description{
Submit a launcher job. See https://docs.rstudio.com/job-launcher/latest/index.html
for more information.
}
\seealso{
Other job submission: \code{\link{launcherConfig}},
  \code{\link{launcherContainer}},
  \code{\link{launcherHostMount}},
  \code{\link{launcherNfsMount}},
  \code{\link{launcherPlacementConstraint}},
  \code{\link{launcherResourceLimit}},
  \code{\link{launcherSubmitR}}
}
\concept{job submission}
