% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/friedman_test.R
\name{friedman_test}
\alias{friedman_test}
\title{Friedman Rank Sum Test}
\usage{
friedman_test(data, formula, ...)
}
\arguments{
\item{data}{a data.frame containing the variables in the formula.}

\item{formula}{a formula of the form \code{a ~ b | c}, where \code{a}
(numeric) is the dependent variable name; \code{b} is the within-subjects
factor variables; and \code{c} (factor) is the column name containing
individuals/subjects identifier. Should be unique per individual.}

\item{...}{other arguments to be passed to the function
\code{\link[stats]{friedman.test}}.}
}
\value{
return a data frame with the following columns: \itemize{ \item
 \code{.y.}: the y (dependent) variable used in the test. \item \code{n}: sample count.
 \item \code{statistic}: the value of Friedman's chi-squared statistic, used to
 compute the p-value. \item \code{p}: p-value. \item \code{method}: the
 statistical test used to compare groups.}
}
\description{
Provides a pipe-friendly framework to perform a Friedman rank sum
 test, which is the non-parametric alternative to the one-way repeated
 measures ANOVA test. Wrapper around the function
 \code{\link[stats]{friedman.test}()}.
}
\examples{
# Load data
#:::::::::::::::::::::::::::::::::::::::
data("ToothGrowth")
df <- ToothGrowth \%>\%
    filter(supp == "VC") \%>\%
    mutate(id = rep(1:10, 3))
head(df)

# Friedman rank sum test
#:::::::::::::::::::::::::::::::::::::::::
df \%>\% friedman_test(len ~ dose | id)

}
