% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doo.R
\name{doo}
\alias{doo}
\title{Alternative to dplyr::do for Doing Anything}
\usage{
doo(data, .f, ..., result = ".results.")
}
\arguments{
\item{data}{a (grouped) data frame}

\item{.f}{A function, formula, or atomic vector. For example
\code{~t.test(len ~ supp, data = .)}.}

\item{...}{Additional arguments passed on to .f}

\item{result}{the column name to hold the results. Default is ".results.".}
}
\value{
a data frame
}
\description{
Provides a flexible alternative to the \code{dplyr:do()} function.
 Technically it uses \code{nest() + mutate() + map()} to apply arbitrary
 computation to a grouped data frame.

 The output is a data frame. If the applied function returns a data frame,
 then the output will be automatically unnested. Otherwise, the output includes the grouping
 variables and a column named ".results." (by default), which is a "list-columns"
 containing the results for group combinations.
}
\examples{
# Example 1: pipe-friendly t_test().
# Two possibilities of usage are available
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# Use this
ToothGrowth \%>\%
  group_by(dose) \%>\%
  doo(~t_test(data =., len ~ supp))

# Or this
ToothGrowth \%>\%
  group_by(dose) \%>\%
  doo(t_test, len ~ supp)

# Example 2: R base function t.test() (not pipe friendly)
# One possibility of usage
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
comparisons <- ToothGrowth \%>\%
   group_by(dose) \%>\%
   doo(~t.test(len ~ supp, data =.))
comparisons
comparisons$.results.

# Example 3: R base function combined with tidy()
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
ToothGrowth \%>\%
   group_by(dose) \%>\%
   doo(~t.test(len ~ supp, data =.) \%>\% tidy())
}
