% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_pvalue.R
\name{adjust_pvalue}
\alias{adjust_pvalue}
\title{Adjust P-values for Multiple Comparisons}
\usage{
adjust_pvalue(data, p.col, output.col, method = "holm")
}
\arguments{
\item{data}{a data frame containing a p-value column}

\item{p.col}{column name containing p-values}

\item{output.col}{the output column name to hold the adjusted p-values}

\item{method}{method for adjusting p values (see
\code{\link[stats]{p.adjust}}). Allowed values include "holm", "hochberg",
"hommel", "bonferroni", "BH", "BY", "fdr", "none". If you don't want to
adjust the p value (not recommended), use p.adjust.method = "none".}
}
\value{
a data frame
}
\description{
A pipe-friendly function to add an adjusted p-value column into
  a data frame.
}
\examples{
# Perform pairwise comparisons and adjust p-values
ToothGrowth \%>\%
 t_test(len ~ dose) \%>\%
 adjust_pvalue()

}
