% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_lik.R
\name{log_lik.stanreg}
\alias{log_lik}
\alias{log_lik.stanreg}
\title{Pointwise log-likelihood matrix}
\usage{
\method{log_lik}{stanreg}(object, newdata = NULL, offset = NULL, ...)
}
\arguments{
\item{object}{A fitted model object returned by one of the 
\pkg{rstanarm} modeling functions. See \code{\link{stanreg-objects}}.}

\item{newdata}{An optional data frame of new data (e.g. holdout data) to use
when evaluating the log-likelihood. See the description of \code{newdata}
for \code{\link{posterior_predict}}.}

\item{offset}{A vector of offsets. Only required if \code{newdata} is
specified and an \code{offset} was specified when fitting the model.}

\item{...}{Currently ignored.}
}
\value{
An \eqn{S} by \eqn{N} matrix, where \eqn{S} is the size of the
  posterior sample and \eqn{N} is the number of data points.
}
\description{
For models fit using MCMC only, the \code{log_lik} method returns the
\eqn{S} by \eqn{N} pointwise log-likelihood matrix, where \eqn{S} is the size
of the posterior sample and \eqn{N} is the number of data points.
}
\examples{
\donttest{
 roaches$roach100 <- roaches$roach1 / 100
 fit <- stan_glm(
    y ~ roach100 + treatment + senior,
    offset = log(exposure2),
    data = roaches,
    family = poisson(link = "log"),
    prior = normal(0, 2.5),
    prior_intercept = normal(0, 10),
    iter = 500 # to speed up example
 )
 ll <- log_lik(fit)
 dim(ll)
 all.equal(ncol(ll), nobs(fit))

 # using newdata argument
 nd <- roaches[1:2, ]
 nd$treatment[1:2] <- c(0, 1)
 ll2 <- log_lik(fit, newdata = nd, offset = c(0, 0))
 head(ll2)
 dim(ll2)
 all.equal(ncol(ll2), nrow(nd))
}

}

