% Generated by roxygen2 (4.0.2): do not edit by hand
\name{peek_back<-}
\alias{peek_back<-}
\title{Assign to/modify the back of an rdeque}
\usage{
peek_back(d, ...) <- value
}
\arguments{
\item{d}{rdeque to modify the back element of.}

\item{...}{additional arguments to be passed to or from methods.}

\item{value}{value to assign to the back data element.}
}
\value{
modified rdeque.
}
\description{
Allows modification access to the back of a deque.
}
\details{
Runs in \eqn{O(1)} worst case time. Throws an error if the deque is empty.
}
\examples{
d <- rdeque()
d <- insert_front(d, data.frame(a = 1, b = 1))
d <- insert_front(d, data.frame(a = 1, b = 1))

peek_back(d)$a <- 100
print(d)

peek_back(d) <- data.frame(a = 100, b = 100)
}
\seealso{
\code{\link{peek_back.rdeque}} for accessing the back element.
}

