% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queryables-query.R
\name{queryables}
\alias{queryables}
\title{Endpoint functions}
\usage{
queryables(q)
}
\arguments{
\item{q}{a \code{RSTACQuery} object expressing a STAC query criteria.}
}
\value{
A \code{RSTACQuery} object with the subclass \code{queryables} for \verb{/queryables}
endpoint.
}
\description{
The queryables endpoint allows the user to discover which
properties can be used in the filter extension.
This endpoint can be accessed from the catalog (\verb{/queryables})
or from a collection (\verb{/collections/\{collection_id\}/queryables}).
}
\examples{
\dontrun{
# Catalog's queryables
rstac::stac("https://planetarycomputer.microsoft.com/api/stac/v1") \%>\%
  rstac::queryables() \%>\% rstac::get_request()

# Collection's queryables
rstac::stac("https://planetarycomputer.microsoft.com/api/stac/v1") \%>\%
  rstac::collections(collection_id = "sentinel-2-l2a") \%>\%
  rstac::queryables() \%>\%
  rstac::get_request()
}

}
\seealso{
\code{\link[=ext_filter]{ext_filter()}},  \code{\link[=conformance]{conformance()}}, \code{\link[=collections]{collections()}}
}
