% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{items_fields}
\alias{items_fields}
\title{Utility functions}
\usage{
items_fields(items, ..., field = NULL)
}
\arguments{
\item{items}{a \code{STACItemCollection} object representing
the result of \code{/stac/search}, \code{/collections/{collectionId}/items}.}

\item{...}{a named way to provide field names to get the subfields values
from the \code{RSTACDocument} objects.}

\item{field}{a \code{character} with the names of the field to get the
subfields values from the \code{RSTACDocument} objects.}
}
\value{
a \code{character} with the subfields of the \code{feature} field.
}
\description{
This function returns the subfields of the \code{feature}
field of a \code{STACItemCollection} object.
}
\examples{
\donttest{
# STACItemCollection object
stac_item <- stac("http://brazildatacube.dpi.inpe.br/stac/") \%>\%
 stac_search(collections = "CB4_64_16D_STK-1", limit = 10,
        datetime = "2017-08-01/2018-03-01") \%>\%
 get_request()

stac_item \%>\% items_fields(field = c("properties"))
}

}
