% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{oasis}
\alias{oasis}
\title{Longitudinal MRI data in nondemented and demented older adults.}
\format{
A data frame with 115 rows and 11 variables:
\describe{
\item{subject_id}{unique subject identifier}
\item{visit}{visit order}
\item{time_of_ad}{visit in which a patient first had AD diagnosis}
\item{m_f}{male or female}
\item{educ}{years of education}
\item{ses}{socioeconomic status (-1 for missing)}
\item{age}{age of patient at visit}
\item{mr_delay}{MR delay time (contrast)}
\item{e_tiv}{estimated total intracranial volume}
\item{n_wbv}{normalized whole brain volume}
\item{asf}{atlas scaling factor}
}
}
\source{
\url{https://www.kaggle.com/jboysen/mri-and-alzheimers?select=oasis_longitudinal.csv}
}
\usage{
oasis
}
\description{
A dataset containing baseline and time-varying information relating to
Alzheimer's disease (AD) based on the \href{https://www.oasis-brains.org/}{Open Access Series of Imaging Studies} (OASIS). This set consists of a
longitudinal collection of 51 subjects aged 62 to 92. Each subject was
scanned on two or more visits, separated by at least one year for a total of
115 imaging sessions. For each subject, 3 or 4 individual T1-weighted MRI
scans obtained in single scan sessions are included.
}
\details{
The data was originally hosted in this Kaggle repository:
\url{https://www.kaggle.com/jboysen/mri-and-alzheimers?select=oasis_longitudinal.csv}.
It has been harmonized for an example analysis for risk set matching based on
a reduced sample including patients who go from mild cognitive impairment
(MCI) to AD and those patients with MCI throughout.
}
\keyword{datasets}
