% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarities.R
\name{sims}
\alias{sims}
\alias{similarities}
\title{similarities}
\usage{
sims(...)

similarities(
  docs,
  all = FALSE,
  coeff = c("jaccard", "braun", "dice", "hamann", "kappa", "kulczynski", "ochiai",
    "phi", "russelrao", "matching", "simpson", "sneath", "tanimoto", "yule")
)
}
\arguments{
\item{...}{all parameters in \code{sims} are given to \code{similarities}}

\item{docs}{document object}

\item{all}{logical: should the similarity coefficients computed based on all sourcecode objects or just the two considered (default: \code{FALSE})}

\item{coeff}{character: coefficient to compute (default: \code{"jaccard"}), abbreviations can be used}
}
\value{
a data frame with the results
}
\description{
\code{sims} and \code{similarities} both calculate for each pair of source code objects
the similarity coefficients and return a data frame with the coefficients in descending order.
A larger coefficient means a greater similarity.
}
\examples{
# example files are taken from https://CRAN.R-project.org/package=SimilaR
files <- list.files(system.file("examples", package="rscc"), "*.R$", full.names=TRUE)
prgs  <- sourcecode(files, basename=TRUE)
docs  <- documents(prgs)
similarities(docs)
}
