% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalaPull.R, R/scalaPush.R
\name{scalaPull}
\alias{scalaPull}
\alias{scalaPush}
\title{Push and Pull Objects Between R and Scala}
\usage{
scalaPull(reference, method, ...)

scalaPush(x, method = "generic", bridge = scalaFindBridge(), ...)
}
\arguments{
\item{reference}{An rscala reference.}

\item{method}{A string giving the specific 'push' or 'pull' method to use.}

\item{...}{Other arguments passed to specialized push and pull functions.}

\item{x}{An R object.}

\item{bridge}{A Scala bridge.}
}
\description{
The push function serializes an R object to Scala and the push function does
the opposite. A couple of built push and pull methods are provided, namely
\code{"generic"} and \code{"list"}. The \code{"generic"} method serializes an
arbitrary R object to an instance of \code{RObject} in Scala. Since the
\code{RObject} merely contains an array of bytes, the \code{RObject} is
really only useful as storage for later unserialization. The \code{"generic"}
method has an optional \code{as.is} argument which is either \code{TRUE} to
cause the list to serialized as a single object or \code{FALSE} to cause each
element of the list to the serialized individually. More methods may be added
using the functions \code{\link{scalaPushRegister}} and
\code{\link{scalaPullRegister}}.
}
\examples{
\donttest{
s <- scala()

s(rn=scalaPush(rnorm),n=5) * 'R.evalD1("\%-(\%-)",rn,n)'

mtcarsRef <- scalaPush(mtcars, "list")
mtcarsRef$names()
mtcarsRef$mpg()
mtcars2 <- scalaPull(mtcarsRef, "list")
identical(mtcars, mtcars2)

# Oops, the variable names are bad...
tryCatch(ref <- scalaPush(iris, "list"), error=function(e) e)

# ... so let's clean up the variable names.
irisCleaned <- iris
names(irisCleaned) <- gsub("\\\\W","_",names(iris))
irisCleaned$Species <- as.character(iris$Species)
ref2 <- scalaPush(irisCleaned, "list")
scalaType(ref2)
ref2$Sepal_Length()
irisCleaned2 <- scalaPull(ref2,"list")
identical(irisCleaned, irisCleaned2)

close(s)
}
 
}
\seealso{
\code{\link{scalaPushRegister}}, \code{\link{scalaPullRegister}}
}
