% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moveCloud.R
\name{moveCloud}
\alias{moveCloud}
\title{moveCloud}
\usage{
moveCloud(x, y, data.path = NULL, buffer.size = NULL, remove.file = FALSE)
}
\arguments{
\item{x}{Object of class \emph{Date} with observation dates of \emph{y}.}

\item{y}{Object of class \emph{SpatialPoints} or \emph{SpatialPointsDataFrame}.}

\item{data.path}{Output data path for downloaded data.}

\item{buffer.size}{Two element vector with temporal buffer size (expressed in days).}

\item{remove.file}{Logical. Should the files be deleted after usage?}
}
\value{
A \emph{list} object reporting on the variability of cloud cover within and around each observation dates.
}
\description{
{Provides historical information on cloud cover for a set of coordinate
pairs. The temporal information is adjusted to the sample observation date.}
}
\details{
{This function uses daily cloud fraction data from NASA's NEO service. For each observation date in \emph{obs.dates},
the function downloads the correspondent image and extracts the percent cloud cover for the corresponding samples in \emph{y}.
Before downloading any data, the function will look within \emph{data.path} for previoulsy acquired data. If they exist, they
won't be downloaded reducing the processing time required by the function. Moreover, if \emph{buffer.size} is specified, for
each date, the function will download all images that are within the specified temporal buffer. \emph{buffer.size} requires a
 twoelement vector which specifies the buffer size before and after the target dates. These additional images will be used to
 report on the closest time step with the lowest possible cloud cover. The final output provides a \emph{data.frame} ($report)
 with information on:
\itemize{
 \item{\emph{cloud cover \% (day)}: cloud cover for the observation dates.}
 \item{\emph{best date (after)}: dates before the observation dates with the lowest cloud cover.}
 \item{\emph{best date cloud cover \% (before)}: cloud cover for best before dates.}
 \item{\emph{best date (after)}: dates after the observation dates with the lowest cloud cover.}
 \item{\emph{best date cloud cover \% (after)}: cloud cover best after dates.}}
 Finally, the function generates a plot ($plot) reporting on the variability of cloud cover
 and the number of observation registered in \emph{y} for each date.}
}
\examples{
\dontrun{

 require(raster)

 # read movement data
 data(shortMove)

 # test function for 30 day buffer
 od <- as.Date(shortMove@data$date)
 c.cover <- moveCloud(shortMove, od, data.path=".", buffer.size=c(30,30))

}
}
\references{
\url{https://cneos.jpl.nasa.gov/}
}
\seealso{
\code{\link{sMoveRes}} \code{\link{tMoveRes}}
}
