% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plausibilityTest.R
\name{plausibilityTest}
\alias{plausibilityTest}
\title{plausibilityTest}
\usage{
plausibilityTest(x, y, class.labels = NULL)
}
\arguments{
\item{x}{Object of class \emph{raster} and \emph{RasterStack} with the x(s).}

\item{y}{Reference \emph{raster} (e.g. Land cover map).}

\item{class.labels}{Labels of classes in \emph{y} provided as a character vector.}
}
\value{
A \emph{list} with statistical information on the distribution of samples per class and a comparative plot.
}
\description{
Quantifies and plots the distribution of pixels within a mask over a reference categorical raster object.
}
\details{
{For each lazer in \emph{x}, the function returns the absolute and relative count of non-NA pixels in \emph{x}
within each class of \emph{y}. Then, the results for each layer are compared in a combined plot. The output of the function
is a list consisting of:
 \itemize{
 \item{\emph{absolute.count} - Absolute sample count for each layer of \emph{x} within each class of \emph{y}.}
 \item{\emph{relative.count} - Relative sample count for each layer of \emph{x} within each class of \emph{y}.}
 \item{\emph{relative.plot} - Plot comparing the relative sample count of the layers in \emph{x} within each class of \emph{y}.}}}
}
\examples{
{

 require(raster)

 # load example probability image
 file <- system.file('extdata', 'probabilities.tif', package="rsMove")
 p <- raster(file) > 0.5

 # land cover map
 lc <- raster(system.file('extdata', 'landCover.tif', package="rsMove"))

 # segment probabilities
 pt <- plausibilityTest(p, lc)

 # show plot
 pt$relative.plot

 # see relative sample count
 head(pt$relative.count)

}
}
