/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.system;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.sparql.core.Quad;
import org.openjena.riot.ErrorHandler;
import org.openjena.riot.RiotException;
import org.openjena.riot.checker.CheckerIRI;
import org.openjena.riot.checker.CheckerLiterals;
import org.openjena.riot.system.ParserProfileBase;
import org.openjena.riot.system.Prologue;

public class ParserProfileChecker
extends ParserProfileBase {
    private boolean checkLiterals = true;
    private boolean resolveURIs = true;

    public ParserProfileChecker(Prologue prologue, ErrorHandler errorHandler) {
        super(prologue, errorHandler);
    }

    public String resolveIRI(String uriStr, long line, long col) {
        return this.makeIRI(uriStr, line, col).toString();
    }

    public IRI makeIRI(String uriStr, long line, long col) {
        IRI iri2 = this.prologue.getResolver().resolveSilent(uriStr);
        CheckerIRI.iriViolations(iri2, this.errorHandler, line, col);
        return iri2;
    }

    public Triple createTriple(Node subject, Node predicate, Node object, long line, long col) {
        this.checkTriple(subject, predicate, object, line, col);
        return super.createTriple(subject, predicate, object, line, col);
    }

    private void checkTriple(Node subject, Node predicate, Node object, long line, long col) {
        if (subject == null || !subject.isURI() && !subject.isBlank()) {
            this.errorHandler.error("Subject is not a URI or blank node", line, col);
            throw new RiotException("Bad subject: " + subject);
        }
        if (predicate == null || !predicate.isURI()) {
            this.errorHandler.error("Predicate not a URI", line, col);
            throw new RiotException("Bad predicate: " + predicate);
        }
        if (object == null || !object.isURI() && !object.isBlank() && !object.isLiteral()) {
            this.errorHandler.error("Object is not a URI, blank node or literal", line, col);
            throw new RiotException("Bad object: " + object);
        }
    }

    public Quad createQuad(Node graph, Node subject, Node predicate, Node object, long line, long col) {
        this.checkQuad(graph, subject, predicate, object, line, col);
        return super.createQuad(graph, subject, predicate, object, line, col);
    }

    private void checkQuad(Node graph, Node subject, Node predicate, Node object, long line, long col) {
        if (graph != null && !graph.isURI()) {
            this.errorHandler.error("Graph name is not a URI", line, col);
            throw new RiotException("Bad graph name: " + graph);
        }
        this.checkTriple(subject, predicate, object, line, col);
    }

    public Node createURI(String x, long line, long col) {
        try {
            String resolvedIRI = this.resolveIRI(x, line, col);
            return Node.createURI((String)resolvedIRI);
        }
        catch (RiotException ex) {
            this.errorHandler.error(ex.getMessage(), line, col);
            throw ex;
        }
    }

    public Node createTypedLiteral(String lexical, RDFDatatype datatype, long line, long col) {
        Node n = Node.createLiteral((String)lexical, null, (RDFDatatype)datatype);
        CheckerLiterals.checkLiteral(lexical, datatype, this.errorHandler, line, col);
        return n;
    }

    public Node createLangLiteral(String lexical, String langTag, long line, long col) {
        Node n = Node.createLiteral((String)lexical, (String)langTag, null);
        CheckerLiterals.checkLiteral(lexical, langTag, this.errorHandler, line, col);
        return n;
    }

    public Node createPlainLiteral(String lexical, long line, long col) {
        return Node.createLiteral((String)lexical);
    }

    public Node createBlankNode(Node scope, String label, long line, long col) {
        return this.labelMapping.get(scope, label);
    }
}

