/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.logging.java;

import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.openjena.atlas.logging.java.TextFormatter;

public class ConsoleHandlerStdout
extends Handler {
    private void configure() {
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        String cls = manager.getProperty(cname + ".formatter");
        Formatter fmt = null;
        try {
            if (cls != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(cls);
                fmt = (Formatter)clz.newInstance();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (fmt == null) {
            fmt = new TextFormatter();
        }
        this.setFormatter(fmt);
    }

    public ConsoleHandlerStdout() {
        this.configure();
    }

    public void close() throws SecurityException {
    }

    public void flush() {
        System.out.flush();
    }

    public void publish(LogRecord record) {
        if (!super.isLoggable(record)) {
            return;
        }
        String s = this.getFormatter().format(record);
        System.out.print(s);
    }
}

